/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.breakpoint;

import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.text.MessageFormat;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.IMarkerUpdater;
import org2.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org2.eclipse.php.internal.debug.ui.breakpoint.provider.PHPBreakpointProvider;

public class BreakpointMarkerUpdater
implements IMarkerUpdater {
    public String[] getAttribute() {
        return new String[]{"lineNumber", "message"};
    }

    public String getMarkerType() {
        return "org2.eclipse.php.debug.core.PHPConditionalBreakpointMarker";
    }

    public boolean updateMarker(IMarker marker, IDocument document, Position position) {
        block4: {
            int newLine;
            block5: {
                if (position.isDeleted()) {
                    return false;
                }
                newLine = document.getLineOfOffset(position.offset) + 1;
                int offset = PHPBreakpointProvider.getValidPosition(document, newLine);
                if (offset == -1) break block4;
                newLine = document.getLineOfOffset(offset) + 1;
                marker.setAttribute("message", (Object)MessageFormat.format(PHPDebugCoreMessages.LineBreakPointMessage_1, marker.getResource().getName(), newLine));
                if (marker.getAttribute("lineNumber", -1) != newLine) break block5;
                return true;
            }
            try {
                marker.setAttribute("lineNumber", newLine);
                return true;
            }
            catch (Exception e) {
                PHPDebugEPLPlugin.logError(e);
            }
        }
        return false;
    }
}

